import { __awaiter } from "tslib";
import Permit2Abi from '../../abis/Permit2.json';
import { Contract } from '@ethersproject/contracts';
export class AllowanceProvider {
    constructor(provider, permit2Address) {
        this.provider = provider;
        this.permit2Address = permit2Address;
        this.permit2 = new Contract(this.permit2Address, Permit2Abi, this.provider);
    }
    getAllowanceData(token, owner, spender) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.permit2.allowance(owner, token, spender);
        });
    }
    getAllowance(token, owner, spender) {
        return __awaiter(this, void 0, void 0, function* () {
            return (yield this.getAllowanceData(token, owner, spender)).amount;
        });
    }
    getNonce(token, owner, spender) {
        return __awaiter(this, void 0, void 0, function* () {
            return (yield this.getAllowanceData(token, owner, spender)).nonce;
        });
    }
    getExpiration(token, owner, spender) {
        return __awaiter(this, void 0, void 0, function* () {
            return (yield this.getAllowanceData(token, owner, spender)).expiration;
        });
    }
}
//# sourceMappingURL=AllowanceProvider.js.map